require(cluster)

Hclust.TOL <- function( dist.bbm, args.R )
  {
    # print( "running Hclust.TOL" );
    dist <- as.dist( read.bbm( dist.bbm ) )
    # Eval non-binary arguments
    source( args.R, local=TRUE )
    m = Hclust_args$method
    size = Hclust_args$size
    hclustResult <- hclust( dist, m );
    groups = cutree( hclustResult, k = size )
    # Write the result
    # print( paste( "writing '", Hclust_args$result.bbm, "'" ) )
    write.bbm( Hclust_args$result.bbm, groups )
  }
