package require Toltcl

lappend auto_path /usr/local/src/TCL/rbctoolkit/trunk/rbc/build8.5
package require rbc

proc Tol_HciWriter { msg } {
  puts [ string trim $msg ]
}

tol::initkernel
tol::initlibrary

set cwd [ file normalize [ file dir [ info script ] ] ]

rbc::graph .gr

tol::include [ file join $cwd "test.tol" ]

pack .gr -fill both -expand yes

tol::seriegrp create s3 { Serie s3 }

set j 0
set t0 [ time {
  foreach vec_data [ s3 serie 0 data ] {
    .gr line create l$j -xdata [ lindex $vec_data 0 ] \
        -ydata [ lindex $vec_data 1 ]
    if { $j } {
      .gr line configure l$j -label ""
    } else {
      .gr line configure l0 -label [ s3 serie 0 name ]
    }
    incr j
  }
} ]

puts "la generacion del grafico tardo [ expr [ lindex $t0 0 ] * 1.0e-6 ] s" 
